<!-- Content Wrapper. Contains page content -->

<div class="content-wrapper">

    <!-- Content Header (Page header) -->

    <section class="content-header">

        <h1>

            <i class="fa fa-money"></i> <?php echo $this->lang->line('fees_collection'); ?></h1>

    </section>

    <!-- Main content -->

    <section class="content">

        <div class="row">

            <?php

            if ($this->rbac->hasPrivilege('fees_group', 'can_add') || $this->rbac->hasPrivilege('fees_group', 'can_edit')) {

                ?>

                <div class="col-md-4">

                    <!-- Horizontal Form -->

                    <div class="box box-primary">

                        <div class="box-header with-border">

                            <h3 class="box-title"><?php echo $this->lang->line('edit_fees_group'); ?></h3>

                        </div><!-- /.box-header -->

                        <!-- form start -->



                        <form action="<?php echo site_url("admin/feegroup/edit/" . $id) ?>"  id="employeeform" name="employeeform" method="post" accept-charset="utf-8">

                            <div class="box-body">



                                <?php if ($this->session->flashdata('msg')) { ?>

                                    <?php echo $this->session->flashdata('msg'); $this->session->unset_userdata('msg'); ?>

                                <?php } ?>

                                <?php

                                if (isset($error_message)) {

                                    echo "<div class='alert alert-danger'>" . $error_message . "</div>";

                                }

                                ?>   

                                <?php echo $this->customlib->getCSRF(); ?>                       

                                <input name="id" type="hidden" class="form-control"  value="<?php echo set_value('id', $feegroup['id']); ?>" />

                                <div class="form-group">

                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('name'); ?></label><small class="req"> *</small>

                                    <input autofocus="" id="name" name="name" placeholder="" type="text" class="form-control"  value="<?php echo set_value('name', $feegroup['name']); ?>" />

                                    <span class="text-danger"><?php echo form_error('name'); ?></span>

                                </div>

                                <div class="form-group">

                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('description'); ?></label>

                                    <textarea class="form-control" id="description" name="description" placeholder="" rows="3" placeholder=""><?php echo set_value('description'); ?><?php echo set_value('description', $feegroup['description']) ?></textarea>

                                    <span class="text-danger"><?php echo form_error('description'); ?></span>

                                </div>

                            </div><!-- /.box-body -->

                            <div class="box-footer">

                                <button type="submit" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>

                            </div>

                        </form>

                    </div>

                </div><!--/.col (right) -->

                <!-- left column -->

            <?php } ?>

            <div class="col-md-<?php

            if ($this->rbac->hasPrivilege('fees_group', 'can_add') || $this->rbac->hasPrivilege('fees_group', 'can_edit')) {

                echo "8";

            } else {

                echo "12";

            }

            ?>">

                <!-- general form elements -->

                <div class="box box-primary">

                    <div class="box-header ptbnull">

                        <h3 class="box-title titlefix"><?php echo $this->lang->line('fees_group_list'); ?></h3>

                        <div class="box-tools pull-right">

                        </div><!-- /.box-tools -->

                    </div><!-- /.box-header -->

                    <div class="box-body">

                        <div class="download_label"><?php echo $this->lang->line('fees_group_list'); ?></div>

                        <div class="mailbox-messages table-responsive overflow-visible">

                            <table class="table table-striped table-bordered table-hover example">

                                <thead>

                                    <tr>

                                        <th><?php echo $this->lang->line('name'); ?></th>

                                        <th class="text-right noExport"><?php echo $this->lang->line('action'); ?></th>

                                    </tr>

                                </thead>

                                <tbody>

                                    <?php

                                    $count = 1;

                                    foreach ($feegroupList as $feegroup) {

                                        ?>

                                        <tr>

                                            <td class="mailbox-name">

                                                <a href="#" data-toggle="popover" class="detail_popover"><?php echo $feegroup['name'] ?></a>

                                                <div class="fee_detail_popover" style="display: none">

                                                    <?php

                                                    if ($feegroup['description'] == "") {

                                                        ?>

                                                        <p class="text text-danger"><?php echo $this->lang->line('no_description'); ?></p>

                                                        <?php

                                                    } else {

                                                        ?>

                                                        <p class="text text-info"><?php echo $feegroup['description']; ?></p>

                                                        <?php

                                                    }

                                                    ?>

                                                </div>

                                            </td>

                                            <td class="mailbox-date pull-right">

                                                <?php

                                                if ($this->rbac->hasPrivilege('fees_group', 'can_edit')) {

                                                    ?>

                                                    <a href="<?php echo base_url(); ?>admin/feegroup/edit/<?php echo $feegroup['id'] ?>" class="btn btn-default btn-xs"  data-toggle="tooltip" title="<?php echo $this->lang->line('edit'); ?>">

                                                        <i class="fa fa-pencil"></i>

                                                    </a>

                                                <?php } ?>

                                                <?php

                                                if ($this->rbac->hasPrivilege('fees_group', 'can_delete')) {

                                                    ?>

                                                    <a href="<?php echo base_url(); ?>admin/feegroup/delete/<?php echo $feegroup['id'] ?>"class="btn btn-default btn-xs"  data-toggle="tooltip" title="<?php echo $this->lang->line('delete'); ?>" onclick="return confirm('<?php echo $this->lang->line('delete_confirm') ?>');">

                                                        <i class="fa fa-remove"></i>

                                                    </a>

                                                <?php } ?>

                                            </td>

                                        </tr>

                                        <?php

                                        $count++;

                                    }

                                    ?>

                                </tbody>

                            </table><!-- /.table -->

                        </div><!-- /.mail-box-messages -->

                    </div><!-- /.box-body -->

                </div>

            </div><!--/.col (left) -->

            <!-- right column -->

        </div>

        <div class="row">

            <div class="col-md-12">

            </div><!--/.col (right) -->

        </div>   <!-- /.row -->

    </section><!-- /.content -->

</div><!-- /.content-wrapper -->



<script>

    $(document).ready(function () {

        $('.detail_popover').popover({

            placement: 'right',

            trigger: 'hover',

            container: 'body',

            html: true,

            content: function () {

                return $(this).closest('td').find('.fee_detail_popover').html();

            }

        });

    });

</script>