<?php



if (!defined('BASEPATH')) {

    exit('No direct script access allowed');

}



class Expense_model extends MY_Model

{



    public function __construct()

    {

        parent::__construct();

        $this->current_session = $this->setting_model->getCurrentSession();

    }



    /**

     * This funtion takes id as a parameter and will fetch the record.

     * If id is not provided, then it will fetch all the records form the table.

     * @param int $id

     * @return mixed

     */


     public function getvoucher($voucherno = null)
     { 

        
        $sql = "select expenses.id,expenses.date,expenses.exp_voucher_no,expenses.expense_mode,expenses.note,expenses.invoice_no,expenses.name,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id from expenses join  expense_head  on expenses.exp_head_id = expense_head.id  where expenses.exp_voucher_no ='$voucherno' order by expenses.invoice_no";

        $query = $this->db->query($sql);

        return $query->result();


     }

    public function search($text = null, $start_date = null, $end_date = null, $voucherno = null, $expense_mode=null)

    {
        // file_put_contents('demochecking1.txt', "texting....."); //
        // file_put_contents('demochecking2.txt', $voucherno); //
        
        file_put_contents('demochecking12222.txt',$text."-". $start_date."-". $end_date."-". $voucherno."-".$expense_mode);

        if ($voucherno !='' || $voucherno == '' || empty($voucherno)) {

file_put_contents("voucher1.txt",$expense_mode);
            $this->datatables

                ->select('expenses.id,expenses.date,expenses.exp_voucher_no,expenses.invoice_no,expenses.name,expenses.amount,expenses.documents,expenses.note,(select sum(amount) from expenses exp where  exp.exp_voucher_no = expenses.exp_voucher_no) as voucher_amount,expense_head.exp_category,expenses.exp_head_id,expenses.expense_mode')
   
                ->join('expense_head', 'expenses.exp_head_id = expense_head.id')

                ->from('expenses')
                
                ->group_by('expenses.exp_voucher_no');


        }
        else if (!empty($text)) {


file_put_contents("textss1.txt",$expense_mode);
            $this->datatables

                ->select('expenses.id,expenses.date,expenses.exp_voucher_no,expenses.invoice_no,expenses.name,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id,expenses.expense_mode')

                ->searchable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')

                ->orderable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')

                ->join('expense_head', 'expenses.exp_head_id = expense_head.id')

                ->like('expenses.name', $text)

                ->from('expenses');



        } else {


            if ($expense_mode != "" || $expense_mode != null){
                file_put_contents("expense_mode1.txt",$expense_mode);
                      
                $this->datatables
    
                    ->select('expenses.id,expenses.date,expenses.exp_voucher_no,expenses.invoice_no,expenses.name,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id,expenses.expense_mode')
    
                    ->searchable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')
    
                    ->orderable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')
    
                    ->join('expense_head', 'expenses.exp_head_id = expense_head.id')
    
                    ->where('expenses.date <=', $end_date)
    
                    ->where('expenses.date >=', $start_date)
                    
                    ->where('expenses.expense_mode', $expense_mode)
                        
                    ->from('expenses');
            }else{
                
                file_put_contents("withnoexpense2_mode.txt",$expense_mode);
                $this->datatables

                ->select('expenses.id,expenses.date,expenses.exp_voucher_no,expenses.invoice_no,expenses.name,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id,expenses.expense_mode')

                ->searchable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')

                ->orderable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')

                ->join('expense_head', 'expenses.exp_head_id = expense_head.id')

                ->where('expenses.date <=', $end_date)

                ->where('expenses.date >=', $start_date)

                ->from('expenses');
            }

        }
                
        // file_put_contents("expenseQry.txt",$this->db->last_query());
        
        return $this->datatables->generate('json');



    }
    
    
    
    public function search2($text = null, $start_date = null, $end_date = null, $voucherno = null, $expense_mode=null)

    {
       if (!empty($text)) {
           
        file_put_contents("textss1.txt",$expense_mode);
        
            $this->datatables

                ->select('expenses.id,expenses.date,expenses.exp_voucher_no,expenses.invoice_no,expenses.name,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id,expenses.expense_mode')

                ->searchable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')

                ->orderable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')

                ->join('expense_head', 'expenses.exp_head_id = expense_head.id')

                ->like('expenses.name', $text)

                ->from('expenses');



        } else {


            if ($expense_mode != "" || $expense_mode != null ){
                // file_put_contents("expense_mode1.txt",$expense_mode);
                      
                $this->datatables
    
                    ->select('expenses.id,expenses.date,expenses.exp_voucher_no,expenses.invoice_no,expenses.name,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id,expenses.expense_mode')
    
                    ->searchable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')
    
                    ->orderable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')
    
                    ->join('expense_head', 'expenses.exp_head_id = expense_head.id')
    
                    ->where('expenses.date <=', $end_date)
    
                    ->where('expenses.date >=', $start_date)
                    
                    ->where('expenses.expense_mode', $expense_mode)
                        
                    ->from('expenses');
            }else{
                
                // file_put_contents("withnoexpense2_mode.txt",$expense_mode);
                $this->datatables

                ->select('expenses.id,expenses.date,expenses.exp_voucher_no,expenses.invoice_no,expenses.name,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id,expenses.expense_mode')

                ->searchable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')

                ->orderable('expenses.name,expenses.invoice_no,exp_category,date,expenses.amount')

                ->join('expense_head', 'expenses.exp_head_id = expense_head.id')

                ->where('expenses.date <=', $end_date)

                ->where('expenses.date >=', $start_date)

                ->from('expenses');
            }

        }
        
        return $this->datatables->generate('json');



    }
    
    public function cancelfeesearch($text = null, $start_date = null, $end_date = null, $receipt = null)
    {

        if (!empty($receipt)) {

            $this->datatables

                ->select('receipt.id,receipt.receipt_no,receipt.comment,receipt.amount,receipt.receipt_date, receipt.fee_detail')

                // ->searchable('receipt.receipt_no')
                ->searchable('receipt.is')

                ->orderable('receipt.receipt_not')

                ->where('receipt.receipt_no', $receipt)
                
                ->where('receipt.is_deleted =', 1) // Added by Hussain on 19_08_2024

                ->from('receipt');


        } else {


            $this->datatables

                ->select('receipt.id,receipt.receipt_no,receipt.comment,receipt.amount,receipt.receipt_date,receipt.fee_detail')

                // ->searchable('receipt.receipt_no')
                ->searchable('receipt.id')

                ->orderable('receipt.receipt_not')

                ->where('receipt.receipt_date >=', $start_date)
                
                ->where('receipt.receipt_date <=', $end_date)
                
                ->where('receipt.is_deleted =', 1) // Added by Hussain on 19_08_2024

                ->from('receipt');

        }

        return $this->datatables->generate('json');



    }



    public function get($id = null)

    {

        $this->db->select('expenses.id,expenses.date,expenses.expense_mode,expenses.name, expenses.exp_voucher_no,expenses.invoice_no,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id')->from('expenses');

        $this->db->join('expense_head', 'expenses.exp_head_id = expense_head.id');

        if ($id != null) {

            $this->db->where('expenses.id', $id);

        } else {

            $this->db->order_by('expenses.id', 'DESC');

        }



        $query = $this->db->get();

        if ($id != null) {

            return $query->row_array();

        } else {

            return $query->result_array();

        }

    }



    public function getexpenselist($id = null)

    {

        $this->datatables

            ->select('expenses.id,expenses.date,expenses.name,expenses.expense_mode,expenses.exp_voucher_no,expenses.invoice_no,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id')

            ->searchable('expenses.id,expenses.date,expenses.name,expenses.exp_voucher_no,expenses.invoice_no,expenses.amount,expenses.documents,expenses.note,expense_head.exp_category,expenses.exp_head_id')

            ->orderable('expenses.name,expenses.note,expenses.exp_voucher_no,expenses.invoice_no,expenses.date,expense_head.exp_category,expenses.amount')

            ->join("expense_head", "expenses.exp_head_id = expense_head.id")

            ->sort('expenses.id', 'desc')

            ->from('expenses');

        return $this->datatables->generate('json');

    }



    /**

     * This function will delete the record based on the id

     * @param $id

     */

    public function remove($id)

    {

        $this->db->trans_start(); # Starting Transaction

        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well

        //=======================Code Start===========================

        $this->db->where('id', $id);

        $this->db->delete('expenses');

        $message   = DELETE_RECORD_CONSTANT . " On  expenses   id " . $id;

        $action    = "Delete";

        $record_id = $id;

        $this->log($message, $record_id, $action);

        //======================Code End==============================



        $this->db->trans_complete(); # Completing transaction

        /* Optional */



        if ($this->db->trans_status() === false) {

            # Something went wrong.

            $this->db->trans_rollback();

            return false;

        } else {



            return $return_value;

        }

    }



    /**

     * This function will take the post data passed from the controller

     * If id is present, then it will do an update

     * else an insert. One function doing both add and edit.

     * @param $data

     */

    public function add($data)

    {

        $this->db->trans_start(); # Starting Transaction

        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well

        //=======================Code Start===========================



        if (isset($data['id']) && $data['id'] != '') {

            $this->db->where('id', $data['id']);

            $this->db->update('expenses', $data);

            $message   = UPDATE_RECORD_CONSTANT . " On  expenses   id " . $data['id'];

            $action    = "Update";

            $record_id = $data['id'];

        } else {

            $this->db->insert('expenses', $data);

            $record_id = $this->db->insert_id();

            $message   = INSERT_RECORD_CONSTANT . " On  expenses   id " . $record_id;

            $action    = "Insert";

        }



        $this->log($message, $record_id, $action);

        //======================Code End==============================



        $this->db->trans_complete(); # Completing transaction

        /* Optional */



        if ($this->db->trans_status() === false) {

            # Something went wrong.

            $this->db->trans_rollback();

            return false;

        } else {

            return $record_id;

        }

    }



    public function check_Exits_group($data)

    {

        $this->db->select('*');

        $this->db->from('expenses');

        $this->db->where('session_id', $this->current_session);

        $this->db->where('feetype_id', $data['feetype_id']);

        $this->db->where('class_id', $data['class_id']);

        $this->db->limit(1);

        $query = $this->db->get();

        if ($query->num_rows() == 1) {

            return false;

        } else {

            return true;

        }

    }



    public function getTypeByFeecategory($type, $class_id)

    {

        $this->db->select('expenses.id,expenses.session_id,expenses.invoice_no,expenses.amount,expenses.documents,expenses.note,expense_head.class,feetype.type')->from('expenses');

        $this->db->join('expense_head', 'expenses.class_id = expense_head.id');

        $this->db->join('feetype', 'expenses.feetype_id = feetype.id');

        $this->db->where('expenses.class_id', $class_id);

        $this->db->where('expenses.feetype_id', $type);

        $this->db->where('expenses.session_id', $this->current_session);

        $this->db->order_by('expenses.id');

        $query = $this->db->get();

        return $query->row_array();

    }



    public function getTotalExpenseBydate($date)

    {

        $query = 'SELECT sum(amount) as `amount` FROM `expenses` where date=' . $this->db->escape($date);

        $query = $this->db->query($query);

        return $query->row();

    }



    public function getTotalExpenseBwdate($date_from, $date_to)

    {

        $query = 'SELECT sum(amount) as `amount` FROM `expenses` where date between ' . $this->db->escape($date_from) . ' and ' . $this->db->escape($date_to);

        $query = $this->db->query($query);

        return $query->row();

    }



    public function getExpenseHeadData($start_date, $end_date)

    {

        $condition = "date_format(date,'%Y-%m-%d') between '" . $start_date . "' and '" . $end_date . "'";

        $recorddata = $this->db->select('sum(amount) as total,exp_category')->from('expenses');

        $this->db->join('expense_head', 'expenses.exp_head_id = expense_head.id');

        $this->db->where($condition)->group_by('expense_head.id');

        $r = $this->db->get()->result_array();

        return $r;

    }



}

