<?php



if (!defined('BASEPATH')) {

    exit('No direct script access allowed');

}



class Contenttype_model extends MY_Model

{



    public function __construct()

    {

        parent::__construct();

    }



    /**

     * This funtion takes id as a parameter and will fetch the record.

     * If id is not provided, then it will fetch all the records form the table.

     * @param int $id

     * @return mixed

     */

    public function get($id = null)

    {

        $this->db->select()->from('content_types');

        if ($id != null) {

            $this->db->where('id', $id);

        } else {

            $this->db->order_by('id');

        }

        $query = $this->db->get();

        if ($id != null) {

            return $query->row();

        } else {

            return $query->result();

        }

    }



    /**

     * This function will delete the record based on the id

     * @param $id

     */

    public function remove($id)

    {

        $this->db->trans_start(); # Starting Transaction

        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well

        //=======================Code Start===========================

        $this->db->where('id', $id);

        $this->db->delete('content_types');

        $message   = DELETE_RECORD_CONSTANT . " On content_types id " . $id;

        $action    = "Delete";

        $record_id = $id;

        $this->log($message, $record_id, $action);

        //======================Code End==============================

        $this->db->trans_complete(); # Completing transaction

        /* Optional */

        if ($this->db->trans_status() === false) {

            # Something went wrong.

            $this->db->trans_rollback();

            return false;

        } else {

            //return $return_value;

        }

    }



    /**

     * This function will take the post data passed from the controller

     * If id is present, then it will do an update

     * else an insert. One function doing both add and edit.

     * @param $data

     */

    public function add($data)

    {

        $this->db->trans_start(); # Starting Transaction

        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well

        //=======================Code Start===========================

        if (isset($data['id'])) {

            $this->db->where('id', $data['id']);

            $this->db->update('content_types', $data);

            $message   = UPDATE_RECORD_CONSTANT . " On  content_types id " . $data['id'];

            $action    = "Update";

            $record_id = $data['id'];

            $this->log($message, $record_id, $action);

            //======================Code End==============================



            $this->db->trans_complete(); # Completing transaction

            /* Optional */



            if ($this->db->trans_status() === false) {

                # Something went wrong.

                $this->db->trans_rollback();

                return false;

            } else {

                //return $return_value;

            }

        } else {

            $this->db->insert('content_types', $data);

            $id        = $this->db->insert_id();

            $message   = INSERT_RECORD_CONSTANT . " On  content_types id " . $id;

            $action    = "Insert";

            $record_id = $id;

            $this->log($message, $record_id, $action);

            //======================Code End==============================



            $this->db->trans_complete(); # Completing transaction

            /* Optional */



            if ($this->db->trans_status() === false) {

                # Something went wrong.

                $this->db->trans_rollback();

                return false;

            } else {

                //return $return_value;

            }

            return $id;

        }

    }



    public function getcontenttypelist()

    {

        $this->datatables

            ->select('content_types.id,content_types.name,content_types.description')

            ->searchable('content_types.name,content_types.description')

            ->orderable('content_types.name,content_types.description')

            ->sort('content_types.id', 'desc')

            ->from('content_types');

        return $this->datatables->generate('json');

    }



}

